# TWSSH Licensing Guide

## Overview

TWSSH is commercial software developed by Terminalworks Ltd. A valid license is required for production use. This guide explains the licensing system, tiers, and activation methods.

For the complete End-User License Agreement, see:
- [LICENSE.txt](../LICENSE.txt) included in this package
- https://twssh.io/license.html

## License Tiers & Pricing

| License | Price | Updates | Developers | Connections | Support SLA |
|---------|-------|---------|------------|-------------|-------------|
| **Trial** | Free | 30 days | - | 2 | - |
| **Developer** | $99 one-time | 2 years | 1 | 5 | 48 hours |
| **Team** | $299 one-time | 2 years | Up to 5 | 25 | 24 hours |
| **Enterprise** | $749 one-time | 2 years | Unlimited | Unlimited | 4 hours |

**All licenses are one-time purchases** that include 2 years of updates and support.

**Note:** "Connections" refers to the maximum number of concurrent SSH connections allowed.

## Feature Comparison

| Feature | Developer | Team | Enterprise |
|---------|:---------:|:----:|:----------:|
| Basic SSH & Commands | Yes | Yes | Yes |
| Interactive Shell | Yes | Yes | Yes |
| SFTP File Transfer | Yes | Yes | Yes |
| SCP File Transfer | Yes | Yes | Yes |
| Public Key Authentication | Yes | Yes | Yes |
| Port Forwarding | | Yes | Yes |
| Keyboard-Interactive Auth | | Yes | Yes |
| Advanced Crypto (ChaCha20) | | Yes | Yes |
| Connection Pooling | | Yes | Yes |
| Priority Support | | Yes | Yes |
| 4-Hour SLA Support | | | Yes |
| Dedicated Account Manager | | | Yes |
| Security Advisory Notifications | | | Yes |
| Custom Integration Support | | | Yes |

## License Tier Details

### Trial License

- **Duration**: 30 days
- **Features**: All Team-tier features (BasicSsh, Shell, Sftp, Scp, PublicKeyAuth, PortForwarding, KeyboardInteractive, AdvancedCrypto, ConnectionPooling)
- **Connections**: 2 concurrent connections
- **Use**: Evaluation only, not for production
- **Cost**: Free, no credit card required

Trial licenses provide access to all Team-tier features so you can fully evaluate the library before purchasing. This includes:
- Basic SSH connections and command execution
- Interactive shell with PTY support
- SFTP and SCP file transfers
- All authentication methods (password, public key, keyboard-interactive)
- Port forwarding (local and remote)
- Advanced cryptographic algorithms (ChaCha20-Poly1305)
- Connection pooling

Request a trial at https://twssh.io

### Developer License - $99 one-time

- **Updates**: 2 years of updates and support included
- **Developers**: 1 individual developer
- **Connections**: 5 concurrent connections
- **Features**: Basic SSH, Shell, Public Key Auth, SFTP, SCP
- **Support**: Email support, 48-hour response time
- **Best for**: Individual developers, small projects

### Team License - $299 one-time

- **Updates**: 2 years of updates and support included
- **Developers**: Up to 5 developers in one organization
- **Connections**: 25 concurrent connections
- **Features**: All Developer features + Port Forwarding, Keyboard-Interactive, Advanced Crypto, Connection Pooling
- **Support**: Priority email support, 24-hour response time
- **Best for**: Small to medium teams

### Enterprise License - $749 one-time

- **Updates**: 2 years of updates and support included
- **Developers**: Unlimited developers in one organization
- **Connections**: Unlimited concurrent connections
- **Features**: All features
- **Support**: 4-hour SLA, dedicated account manager, security advisory notifications
- **Best for**: Large organizations, mission-critical applications

## Developer Counting

A "developer" is counted when they:
- Write code that directly calls TWSSH APIs
- Modify or maintain code that uses TWSSH
- Configure or customize TWSSH behavior

The following do **NOT** count toward your developer limit:
- System administrators deploying applications
- DevOps engineers managing infrastructure
- End users of your applications
- QA testers who don't modify source code

## Activating a License

### Method 1: Initialize with License Key

```csharp
using TwSsh.Licensing;

// At application startup
LicenseManager.Instance.Initialize("YOUR-LICENSE-KEY-HERE");
```

### Method 2: License File

Create a file named `twssh.lic` or `license.lic` containing your license key.

```csharp
LicenseManager.Instance.InitializeFromFile("path/to/license.lic");
```

### Method 3: Auto-Discovery

Place `twssh.lic` in one of these locations:
- Application directory
- `%APPDATA%\TwSsh\license.lic` (Windows)
- `%PROGRAMDATA%\TwSsh\license.lic` (Windows)
- `~/.config/twssh/license.lic` (Linux/macOS)

The library will automatically find and load it.

### Getting a Trial License

Get a free 30-day trial license at [https://twssh.io](https://twssh.io). The download includes a trial license file that you can use with any of the methods above.

## Checking License Status

```csharp
var license = LicenseManager.Instance.CurrentLicense;

Console.WriteLine($"Type: {license.Type}");
Console.WriteLine($"Licensed to: {license.LicenseeName}");
Console.WriteLine($"Expires: {license.ExpirationDate}");
Console.WriteLine($"Days remaining: {license.DaysRemaining}");
Console.WriteLine($"Valid: {license.IsValid}");

// Check specific features
if (LicenseManager.Instance.HasFeature(LicenseFeatures.PortForwarding))
{
    // Port forwarding is available (Team or Enterprise only)
}
```

## License Errors

The library throws `LicenseException` for license-related errors:

```csharp
try
{
    var client = new SshClient(settings);
}
catch (LicenseException ex)
{
    switch (ex.ErrorType)
    {
        case LicenseErrorType.NoLicense:
            Console.WriteLine("No license configured");
            break;
        case LicenseErrorType.Expired:
            Console.WriteLine("License has expired");
            break;
        case LicenseErrorType.FeatureNotLicensed:
            Console.WriteLine("Feature not included in license");
            break;
        case LicenseErrorType.ConnectionLimitExceeded:
            Console.WriteLine("Too many concurrent connections");
            break;
    }
}
```

## Updates & Renewals

### During Your 2-Year Coverage Period

Your license includes:
- All software updates and new versions
- Security patches and bug fixes
- Technical support according to your tier
- Access to documentation and resources

### After 2 Years

When your update coverage expires:
- You may continue using the last version released during your coverage period
- You will not receive new updates, features, or security patches
- Technical support will no longer be available
- Distribution rights for existing applications remain valid

### Renewing Coverage

Contact sales@terminalworks.com to renew your update coverage at a discounted rate.

## Permitted Uses

You MAY:
- Build and distribute applications using TWSSH
- Deploy to unlimited servers and environments
- Distribute applications to unlimited end users
- Use in SaaS products and cloud services
- Include in products that are sold to customers

## Restrictions

You MAY NOT:
- Share or transfer your license to third parties
- Use a single license across multiple organizations
- Redistribute TWSSH as a standalone library
- Reverse engineer or decompile the software
- Create competing SSH library products

## Purchasing a License

Visit **https://twssh.io** to:
- Purchase a license
- Request a free 30-day trial
- Contact sales for custom licensing

## Support

| License | Response Time |
|---------|---------------|
| Developer | 48 hours |
| Team | 24 hours |
| Enterprise | 4 hours |

Contact:
- **Support**: support@twssh.io
- **Sales**: sales@terminalworks.com

---

## Company Information

**Terminalworks Ltd.**
Radnicka 45
51000 Rijeka
Croatia

- VAT: HR89391085276
- Registration: Commercial Court in Rijeka, MBS 040281304

---

Copyright 2025 Terminalworks Ltd. All rights reserved.

- Full License: https://twssh.io/license.html
- Terms of Service: https://twssh.io/terms.html
- Privacy Policy: https://twssh.io/privacy.html
